/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.guis.instances.GUIBooklet;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketPlayer;

public class PacketGUIRequest
extends APacketPlayer {
    private final GUIType guiRequested;

    public PacketGUIRequest(IWrapperPlayer player, GUIType guiRequested) {
        super(player);
        this.guiRequested = guiRequested;
    }

    public PacketGUIRequest(ByteBuf buf) {
        super(buf);
        this.guiRequested = GUIType.values()[buf.readByte()];
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.guiRequested.ordinal());
    }

    @Override
    public void handle(AWrapperWorld world, IWrapperPlayer player) {
        switch (this.guiRequested) {
            case BOOKLET: {
                new GUIBooklet((ItemItem)player.getHeldItem());
            }
        }
    }

    public static enum GUIType {
        BOOKLET;

    }
}

